/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.ruby.formatter.preferences;

import com.aptana.editor.ruby.RubyEditorPlugin;
import com.aptana.formatter.ui.FormatterMessages;
import com.aptana.formatter.ui.IFormatterControlManager;
import com.aptana.formatter.ui.IFormatterModifyDialog;
import com.aptana.formatter.ui.preferences.FormatterModifyTabPage;
import com.aptana.formatter.ui.util.SWTFactory;
import java.net.URL;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;

public class RubyFormatterIndentationTabPage
extends FormatterModifyTabPage {
    private Combo tabPolicy;
    private Text indentSize;
    private Text tabSize;
    private TabPolicyListener tabPolicyListener;
    private final String[] tabPolicyItems = new String[]{"space", "tab", "mixed", "editor"};
    private final String[] tabOptionNames = new String[]{FormatterMessages.IndentationTabPage_general_group_option_tab_policy_SPACE, FormatterMessages.IndentationTabPage_general_group_option_tab_policy_TAB, FormatterMessages.IndentationTabPage_general_group_option_tab_policy_MIXED, FormatterMessages.IndentationTabPage_general_group_option_tab_policy_EDITOR};

    public RubyFormatterIndentationTabPage(IFormatterModifyDialog dialog) {
        super(dialog);
    }

    protected void createOptions(IFormatterControlManager manager, Composite parent) {
        Group tabPolicyGroup = SWTFactory.createGroup((Composite)parent, (String)FormatterMessages.FormatterModifyTabPage_generalSettings, (int)2, (int)1, (int)768);
        this.tabPolicy = manager.createCombo((Composite)tabPolicyGroup, (Object)"ruby.formatter.formatter.tabulation.char", FormatterMessages.IndentationTabPage_general_group_option_tab_policy, this.tabPolicyItems, this.tabOptionNames);
        this.tabPolicyListener = new TabPolicyListener(manager);
        this.tabPolicy.addSelectionListener((SelectionListener)this.tabPolicyListener);
        manager.addInitializeListener((IFormatterControlManager.IInitializeListener)this.tabPolicyListener);
        this.indentSize = manager.createNumber((Composite)tabPolicyGroup, "ruby.formatter.formatter.indentation.size", FormatterMessages.IndentationTabPage_general_group_option_indent_size, 1);
        this.tabSize = manager.createNumber((Composite)tabPolicyGroup, "ruby.formatter.formatter.tabulation.size", FormatterMessages.IndentationTabPage_general_group_option_tab_size, 1);
        this.tabSize.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                boolean tabMode;
                int index = RubyFormatterIndentationTabPage.this.tabPolicy.getSelectionIndex();
                if (index >= 0 && (tabMode = "tab".equals(RubyFormatterIndentationTabPage.this.tabPolicyItems[index]))) {
                    RubyFormatterIndentationTabPage.this.indentSize.setText(RubyFormatterIndentationTabPage.this.tabSize.getText());
                }
            }
        });
        Group indentGroup = SWTFactory.createGroup((Composite)parent, (String)FormatterMessages.RubyFormatterIndentationTabPage_indentDefinitionsGroupTitle, (int)1, (int)1, (int)768);
        manager.createCheckbox((Composite)indentGroup, (Object)"ruby.formatter.indent.class", FormatterMessages.RubyFormatterIndentationTabPage_declarationWithinClassBody);
        manager.createCheckbox((Composite)indentGroup, (Object)"ruby.formatter.indent.module", FormatterMessages.RubyFormatterIndentationTabPage_declarationWithinModuleBody);
        manager.createCheckbox((Composite)indentGroup, (Object)"ruby.formatter.indent.method", FormatterMessages.RubyFormatterIndentationTabPage_declarationWithinMethodBody);
        Group indentBlocks = SWTFactory.createGroup((Composite)parent, (String)FormatterMessages.RubyFormatterIndentationTabPage_indentWithinBlocks, (int)1, (int)1, (int)768);
        manager.createCheckbox((Composite)indentBlocks, (Object)"ruby.formatter.indent.blocks", FormatterMessages.RubyFormatterIndentationTabPage_statementWithinBlocksBody);
        manager.createCheckbox((Composite)indentBlocks, (Object)"ruby.formatter.indent.if", FormatterMessages.RubyFormatterIndentationTabPage_statementWithinIfBody);
        manager.createCheckbox((Composite)indentBlocks, (Object)"ruby.formatter.indent.case", FormatterMessages.RubyFormatterIndentationTabPage_statementWithinCaseBody);
        manager.createCheckbox((Composite)indentBlocks, (Object)"ruby.formatter.indent.when", FormatterMessages.RubyFormatterIndentationTabPage_statementWithinWhenBody);
    }

    protected URL getPreviewContent() {
        return ((Object)((Object)this)).getClass().getResource("indentation-preview.rb");
    }

    private class TabPolicyListener
    extends SelectionAdapter
    implements IFormatterControlManager.IInitializeListener {
        private final IFormatterControlManager manager;

        public TabPolicyListener(IFormatterControlManager manager) {
            this.manager = manager;
        }

        public void widgetSelected(SelectionEvent e) {
            int index = RubyFormatterIndentationTabPage.this.tabPolicy.getSelectionIndex();
            if (index >= 0) {
                boolean tabMode = "tab".equals(RubyFormatterIndentationTabPage.this.tabPolicyItems[index]);
                boolean editorSettingsMode = "editor".equals(RubyFormatterIndentationTabPage.this.tabPolicyItems[index]);
                this.manager.enableControl((Control)RubyFormatterIndentationTabPage.this.indentSize, !tabMode && !editorSettingsMode);
                this.manager.enableControl((Control)RubyFormatterIndentationTabPage.this.tabSize, !editorSettingsMode);
                if (editorSettingsMode) {
                    RubyFormatterIndentationTabPage.this.setEditorTabWidth(RubyEditorPlugin.getDefault().getBundle().getSymbolicName(), new Text[]{RubyFormatterIndentationTabPage.this.tabSize, RubyFormatterIndentationTabPage.this.indentSize});
                }
            }
        }

        public void initialize() {
            boolean tabMode = "tab".equals(this.manager.getString((Object)"ruby.formatter.formatter.tabulation.char"));
            boolean editorSettingsMode = "editor".equals(this.manager.getString((Object)"ruby.formatter.formatter.tabulation.char"));
            this.manager.enableControl((Control)RubyFormatterIndentationTabPage.this.indentSize, !tabMode && !editorSettingsMode);
            this.manager.enableControl((Control)RubyFormatterIndentationTabPage.this.tabSize, !editorSettingsMode);
            if (editorSettingsMode) {
                RubyFormatterIndentationTabPage.this.setEditorTabWidth(RubyEditorPlugin.getDefault().getBundle().getSymbolicName(), new Text[]{RubyFormatterIndentationTabPage.this.tabSize, RubyFormatterIndentationTabPage.this.indentSize});
            }
        }
    }
}

